function [z,jac]=gauss2dfunct(p,grid)

% 2d gaussian function that allows calculation for elliptical gaussian,
% with certain tilt. This gaussian function is adapted from the IDL version
% of GAUSS2_FUNCT.

% Input: 
% 'p' is an array of 6 or 7 elements. If it has 7 elements, tilt will
% be included. The parameters are: z-offset, amplitude, x-stdev, y-stdev,
% x-center, y-center, tilt.
% 'grid' is an array consisting of the dimension in x (grid(1)) and y (grid(2)),
% and the gridding in x and y (which will be placed right after the 
% dimensions, in the same column array). This input is [nx ny x y].

% Output:
% The outputs are the 2d gaussian function denoted as 'z', and the jacobian
% denoted as 'jac'.

nx=grid(1);             % Obtain the dimensions in x and y
ny=grid(2);

% Allocating parameters to variables
a=p(1); b=p(2); c=p(3); d=p(4); e=p(5); f=p(6);

% Jacobian of 2d gaussian function
m=length(p);            % Find out the number of parameters
jac=zeros(ny*nx,m);     % Allocate memory for jac
x = reshape(repmat(1:nx,ny,1),nx*ny,1);
y = reshape(repmat((1:ny)',1,nx),nx*ny,1);

tilt=length(p)==7;
if tilt==1
    g = p(7);
    xpt=repmat((grid(3:nx+2)-e),[ny 1]);         % Expand x values
    ypt=repmat((grid(nx+3:end)'-f),[1 nx]);      % Expand y values
    s=sin(p(7));                                    % Values of sin and cos
    cs=cos(p(7));
    xp=reshape(xpt*(cs/c) - ypt*(s/c),ny*nx,1);   % Make 1d
    yp=reshape(xpt*(s/d) + ypt*(cs/d),ny*nx,1);   % Make 1d
    expU=exp(-0.5*(xp.*xp+yp.*yp));     % Find exp term
    z=a+b*expU;                   % Calculate z
%     z = a+b*exp(-0.5*((((x-e)*cos(g)-(y-f)*sin(g))/c).^2 + (((x-e)*sin(g)+(y-f)*cos(g))/d).^2));
    
    % Determine partial derivatives
    if nargout>1        % Jacobian required
        pexpU=b*expU;
%         Ux=pexpU.*xp/c;
%         Uy=pexpU.*yp/d;
        jac(:,1)=1;
        jac(:,2)=expU;
%         jac(:,3)=Ux/c;
%         jac(:,4)=Uy/d;
        jac(:,3)=pexpU.*xp.*xp/c;
        jac(:,4)=pexpU.*yp.*yp/d;
        jac(:,5)=pexpU.*xp/c*cs+pexpU.*yp/d*s;
        jac(:,6)=-pexpU.*xp/c*s+pexpU.*yp/d*cs;
        jac(:,7)=-pexpU.*xp.*yp*(c/d-d/c);

%         jac(:,1)=1;
%         jac(:,2)=exp(-(cos(g)*(e-x) - sin(g)*(f-y)).^2/(2*c^2) - (cos(g)*(f-y) + sin(g)*(e-x)).^2/(2*d^2));
%         jac(:,3)=(b*exp(-(cos(g)*(e-x) - sin(g)*(f-y)).^2/(2*c^2) - (cos(g)*(f-y) + sin(g)*(e-x)).^2/(2*d^2)).*(cos(g)*(e-x) - sin(g)*(f-y)).^2)/c^3;
%         jac(:,4)=(b*exp(-(cos(g)*(e-x) - sin(g)*(f-y)).^2/(2*c^2) - (cos(g)*(f-y) + sin(g)*(e-x)).^2/(2*d^2)).*(cos(g)*(f-y) + sin(g)*(e-x)).^2)/d^3;
%         jac(:,5)=-b*exp(-(cos(g)*(e-x) - sin(g)*(f-y)).^2/(2*c^2) - (cos(g)*(f-y) + sin(g)*(e-x)).^2/(2*d^2)).*((cos(g)*(cos(g)*(e-x) - sin(g)*(f-y)))/c^2 + (sin(g)*(cos(g)*(f-y) + sin(g)*(e-x)))/d^2);
%         jac(:,6)=-b*exp(-(cos(g)*(e-x) - sin(g)*(f-y)).^2/(2*c^2) - (cos(g)*(f-y) + sin(g)*(e-x)).^2/(2*d^2)).*((cos(g)*(cos(g)*(f-y) + sin(g)*(e-x)))/d^2 - (sin(g)*(cos(g)*(e-x) - sin(g)*(f-y)))/c^2);
%         jac(:,7)=b*exp(-(cos(g)*(e-x) - sin(g)*(f-y)).^2/(2*c^2) - (cos(g)*(f-y) + sin(g)*(e-x)).^2/(2*d^2)).*(((cos(g)*(f-y) + sin(g)*(e-x)).*(cos(g)*(e-x) - sin(g)*(f-y)))/c^2 - ((cos(g)*(f-y) + sin(g)*(e-x)).*(cos(g)*(e-x) - sin(g)*(f-y)))/d^2);
        
    end
    
else
    xp=reshape(repmat((grid(3:nx+2)-e)/c,[ny 1]),ny*nx,1);       % Expand x values, make 1d
    yp=reshape(repmat((grid(nx+3:end)'-f)/d,[1 nx]),ny*nx,1);    % Expand y values, make 1d
    expU=exp(-0.5*(xp.*xp+yp.*yp));     % Find exp term
    z=a+b*expU;                   % Calculate z
    %z = a+b*exp(-0.5*((x-e).^2/c^2 + (y-f).^2/d^2));
    
    % Determine partial derivatives
    if nargout>1        % Jacobian required
        pexpU=b*expU;
%         Ux=pexpU.*xp/c;
%         Uy=pexpU.*yp/d;
        jac(:,1)=1;
        jac(:,2)=expU;
%         jac(:,3)=Ux/c;
%         jac(:,4)=Uy/d;
        jac(:,3)=pexpU.*xp.*xp/c;
        jac(:,4)=pexpU.*yp.*yp/d;
        jac(:,5)=pexpU.*xp/c;
        jac(:,6)=pexpU.*yp/d;

%         jac(:,1)=1;
%         jac(:,2)=exp(-(e-x).^2/(2*c^2) - (f-y).^2/(2*d^2));
%         jac(:,3)=(b*exp(-(e-x).^2/(2*c^2) - (f-y).^2/(2*d^2)).*(e-x).^2)/c^3;
%         jac(:,4)=(b*exp(-(e-x).^2/(2*c^2) - (f-y).^2/(2*d^2)).*(f-y).^2)/d^3;
%         jac(:,5)=-(b*exp(-(e-x).^2/(2*c^2) - (f-y).^2/(2*d^2)).*(e-x))/(c^2);
%         jac(:,6)=-(b*exp(-(e-x).^2/(2*c^2) - (f-y).^2/(2*d^2)).*(f-y))/(d^2);

    end
end

end
